﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.WebApplication.Statistics
{
    public partial class Instructor : StatsBaseComponent
    {
        protected class StudentCompetencePanel : StatsPanel
        {
            public StudentCompetencePanel(StatsBaseComponent Component) : base(Component) { }

            public override void Load()
            {
                if (!StudentID.HasValue)
                {
                    return;
                }
                BL.BO.Student _student = Component.BLELearning.Student.Restore(StudentID);
                if (_student == null)
                {
                    return;
                }
                Component.AppendToXML(_student);

                // to jest tak na prawde statystyka studenta - wiec powinien byc tylko jeden wpis
                List<BL.BO.Student> _listStudent = new List<BL.BO.Student>();
                _listStudent.Add(_student);
                AppendToXML(_listStudent);

                // lista kompetencji glownych z danymi sumarycznymi dla studenta
                // wewnatrz metody AppendToXML dodawane jest rozbicie poziomow trudnosci
                AppendToXML(_student, Component.BLELearning.Statistic.CompetenceStatistic.Restore(_student));

                // Lista stopni zaawansowania
                AppendToXML(Component.BLELearning.AdvancedLevel.Restore());

                // Lista ocen
                AppendToXML(Component.BLELearning.EvaluationSheet.Restore());
            }

            public override bool Save()
            {
                return true;
            }
        }
    }
}